﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.DAL;

namespace AZVIC.Ei8htPOS.BAL
{
    [DataObjectAttribute()]
    public static class HappyHourPromoBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static HappyHours GetItem(Guid PromoID)
        {
            return HappyHourPromoDB.GetItem(PromoID);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<HappyHours> GetList(Guid PromoID)
        {
            return HappyHourPromoDB.GetList(PromoID);
        }

       
        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(HappyHours PromoItem)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                HappyHourPromoDB.Save(PromoItem);

                myTransactionScope.Complete();
                return true;
            }
        }

        public static bool Delete(Guid PromoID)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                HappyHourPromoDB.Delete(PromoID);

                myTransactionScope.Complete();
                return true;
            }
        }

    }
}
